--Initial campaign triggers (static file, not updated)
--Copied to Status/camp_triggers.lua in first mission and subsequently read and updated there
--Campaign triggers are defined with conditions and actions
-------------------------------------------------------------------------------------------------------
-- Miguel Fichier Revision M19
------------------------------------------------------------------------------------------------------- 
-- Miguel21 modification M19 : Repair SAM

--List of Return functions to build conditions:
--Return.Time()							returns time of day in seconds
--Return.Day()							returns day of month
--Return.Month()						returns month as number
--Return.Year()							returns year as number
--Return.Mission()						returns campaign mission number
--Return.CampFlag(flag-n)				returns value of campaign flag
--Return.AirUnitActive("UnitName")		returned boolean whether the air unit is active			
--Return.AirUnitReady("UnitName")		returns amount of ready aircraft in unit
--Return.AirUnitAlive("UnitName")		returns amount of ready and damaged aircraft in unit
--Return.AirUnitBase("UnitName")		returns the name of the airbase the unit operats from
--Return.AirUnitPlayer("UnitName")		returns boolean whether the air units is playable
--Return.TargetAlive("TargetName")		returns percentage of alive sub elements in target
--Return.GroupHidden("GroupName")		returns group hidden status
--Return.GroupProbability("GroupName")	returns group spawn probability value between 0 and 1

--List of Action functions for trigger actions:
--Action.None()
--Action.Text("your briefing text")
--Action.SetCampFlag(flag-n, boolean/number)
--Action.AddCampFlag(flag-n, number)
--Action.AddImage("filename.jpg", "blue") -- "blue" "red" "all"
--Action.CampaignEnd("win"/"draw"/"loss")
--Action.TargetActive("TargetName", boolean)
--Action.AirUnitActive("UnitName", boolean)
--Action.AirUnitBase("UnitName", "BaseName")
--Action.AirUnitPlayer("UnitName", boolean)
--Action.AirUnitReinforce("SourceUnitName", "DestinationUnitName", destNumber)
--Action.AirUnitRepair()
--Action.GroundUnitRepair()
--Action.AddGroundTargetIntel("sideName")
--Action.GroupHidden("GroupName", boolean)
--Action.GroupProbability("GroupName", number 0-1)

--Important notes:
--for condition and action strings: outside with single quotes '', inside with double quotes ""!

camp_triggers = {
	
	----- CAMPAIGN INTRO ----
	["Campaign Briefing"] = {										--Trigger name
		active = true,												--Trigger is active
		once = true,												--Trigger is fired once
		condition = 'true',											--Condition of the trigger to return true or false embedded as string
		action = {													--Trigger action function embedded as string
			[1] = 'Action.Text("Operation Overlord")',
			[2] = 'Action.Text("Allied troops have landed on the beches of Normandy!")',
			[3] = 'Action.Text("They have established a beach head and started to push South.  Destroy their Airbases, Ground foreces and Supply ships.")',
			[4] = 'Action.Text("Support our ground forces and push the Allies back into the ocean.")',
			[5] = 'Action.AddImage("operation-overlord-map.png", "all")',
			-- [4] = 'Action.Text("The Bullseye Coordinates are N 42 11 50 97 - E 41 38 31 12.")',
		},
	},
	
----- CAMPAIGN SITUATION -----
	["Campaign first destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["red"].percent < 100',
		action = {
			[1] = 'Action.Text("First targets have been destroyed. Keep up the good work")',
		},
	},
	["Campaign 20 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["red"].percent < 80',
		action = {
			[1] = 'Action.Text("Enemy targets have sustained fair damages. Keep up the good work")',
		},
	},
	["Campaign 40 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["red"].percent < 60',
		action = {
			[1] = 'Action.Text("Enemy targets have sustained great damages. Strike missions are really efficient and we will win this war soon")',
		},
	},
	["Campaign 50 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["red"].percent < 50',
		action = {
			[1] = 'Action.Text("More than half of our targets are neutralized. Intelligence think that the enemy will ask for a cease fire soon")',
		},
	},

	
	----- CAMPAIGN END -----
	["Campaign End Victory 1"] = {
		active = true,
		once = false,
		condition = 'GroundTarget["red"].percent < 30',
		action = {
			[1] = 'Action.CampaignEnd("win")',
			[2] = 'Action.Text("You have repelled the enemy")',
			[3] = 'Action.AddImage("Newspaper_FranceCaptured.jpg", "all")',
			[4] = 'NoMoreNewspaper = true',
		},
	},
	["Campaign End Victory 2"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitReady("352nd Fighter Group") + Return.AirUnitReady("353rd Fighter Group") + Return.AirUnitReady("No. 19 Squadron RAF") + Return.AirUnitReady("No. 20 Squadron RAF") + Return.AirUnitReady("362 Fighter Group") + Return.AirUnitReady("363 Fighter Group") + Return.AirUnitReady("R/P51 Fighter Group") + Return.AirUnitReady("R/RAF") + Return.AirUnitReady("R/P-47-30") < 1',
			action = {
			[1] = 'Action.CampaignEnd("win")',
			[2] = 'Action.Text("Your have pushed the Allies back into the ocean.")',
			[3] = 'Action.AddImage("Newspaper_FranceCaptured.jpg", "all")',
			[4] = 'NoMoreNewspaper = true',
		},
	},
	["Campaign End Loss"] = {
		active = true,
		once = false,
		condition = 'Return.AirUnitAlive("Jagdgeschwader 28") + Return.AirUnitReady("R/BF109") < 4',
		action = {
			[1] = 'Action.CampaignEnd("loss")',
			[2] = 'Action.Text("You have taken too many loses.  We would no longer be able to achieve air superiority")',
			[3] = 'Action.AddImage("Newspaper_VEDay.jpg", "all")',
			[4] = 'NoMoreNewspaper = true',
		},
	},
	["Campaign Victory 3"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("Naval Supply 1") == 0 and Return.TargetAlive("Naval Supply 2") == 0',
		action = {
			[1] = 'Action.CampaignEnd("win")',
			[2] = 'Action.Text("You have choked their supply lines.  It is only a matter of time now before the retreat.")',
			[3] = 'Action.AddImage("Newspaper_VEDay.jpg", "all")',
			[4] = 'NoMoreNewspaper = true',
		},
	},	
	["Campaign End Draw"] = {
		active = true,
		once = true,
		condition = 'MissionInstance == 40',
		action = {
			[1] = 'Action.CampaignEnd("draw")',
			[2] = 'Action.Text("The air campaign has seen a sustained period of inactivity. Seemingly unable to complete the destruction of the Russian Air Force and infrastructure, US Central Command has called off all squadrons from offensive operations. We hope negociations with Russians will convince them to withdraw from Georgia")',
			[3] = 'NoMoreNewspaper = true',
		},
	},

	----- CONVOY MOVEMENT -----
	["Naval Supply 1"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = 'Action.ShipMission("Naval Supply 1", {{"Sierra 1-1", "Sierra 1-2", "Sierra 1-3", "Sierra 1-4"}}, 8, 5, nil)',
	},
	["Naval Supply 2"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = 'Action.ShipMission("Naval Supply 2", {{"Sierra 2-1", "Sierra 2-2", "Sierra 2-3", "Sierra 2-4"}}, 8, 5, nil)',
	},
	["Landing Force"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = 'Action.ShipMission("Landing Force", {{"LF1-1", "LF1-2", "LF1-3", "LF1-4", "LF1-5"}}, 11, 5, nil)',
	},


	----- UNIT DESACTIVATION -----
--[[	["Unit Desactivate B-52H and B-1B"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() >= 10',
		action = {
			-- [1] = 'Action.AirUnitActive("96 BW", false)',
			[1] = 'Action.AirUnitActive("69 BS", false)',
			[2] = 'Action.Text("After intensive flights against Russians SAM sites, B-52H from 96 BS and B-1B from 69 BS have reduced significantly SAM sites effectiveness. They have to stop their missions but it should be easier for TF-74 to attack strategics targets in Georgia")',
			-- [4] = 'Action.AddImage("Newspaper_Phantom.jpg")',
		},
	},	--]]

	----- AIRBASE STRIKES -----
	["Cricqueville-en-Bessin Airbase Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("Cricqueville-en-Bessin Airbase") < 2',
		action = {
			[1] = 'db_airbases["Cricqueville-en-Bessin"].inactive = true',
		}
	},
	["Cricqueville-en-Bessin Airbase Disabled Text"] = {
		active = true,
		once = false,
		condition = 'Return.TargetAlive("Cricqueville-en-Bessin Airbase") < 2',
		action = {
			[1] = 'Action.Text("After the facilities at Cricqueville-en-Bessin Airbase have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer ably to produce any aviation sorties.")',
		}
	},
	["Longues-sur-mer Airbase Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("Longues-sur-mer Airbase") < 2',
		action = {
			[1] = 'db_airbases["Lonues-sur-mer"].inactive = true',
		}
	},
	["Longues-sur-mer Airbase Disabled Text"] = {
		active = true,
		once = false,
		condition = 'Return.TargetAlive("Longues-sur-mer Airbase") < 2',
		action = {
			[1] = 'Action.Text("After the facilities at Lonues-sur-mer Airbase have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer ably to produce any aviation sorties.")',
		}
	},
	["Saint-Pierre-du-Mont Airbase Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("Saint-Pierre-du-Mont Airbase") < 2',
		action = {
			[1] = 'db_airbases["Saint-Pierre-du-Mont"].inactive = true',
		}
	},
	["Saint-Pierre-du-Mont Airbase Disabled Text"] = {
		active = true,
		once = false,
		condition = 'Return.TargetAlive("Saint-Pierre-du-Mont Airbase") < 2',
		action = {
			[1] = 'Action.Text("After the facilities at Saint-Pierre-du-Mont Airbase have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer ably to produce any aviation sorties.")',
		}
	},
	["Sainte-Laurent-sur-mer Airbase Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("Sainte-Laurent-sur-mer Airbase") < 2',
		action = {
			[1] = 'db_airbases["Sainte-Laurent-sur-mer"].inactive = true',
		}
	},
	["Sainte-Laurent-sur-mer Airbase Disabled Text"] = {
		active = true,
		once = false,
		condition = 'Return.TargetAlive("Sainte-Laurent-sur-mer Airbase") < 2',
		action = {
			[1] = 'Action.Text("After the facilities at Sainte-Laurent-sur-mer Airbase have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer ably to produce any aviation sorties.")',
		}
	},	
	["Sommervieu Airbase Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("Sommervieu Airbase") < 2',
		action = {
			[1] = 'db_airbases["Sommervieu"].inactive = true',
		}
	},
	["Sommervieu Airbase Disabled Text"] = {
		active = true,
		once = false,
		condition = 'Return.TargetAlive("Sommervieu Airbase") < 2',
		action = {
			[1] = 'Action.Text("The infrastructure at Sommervieu Airbase has been destroyed by air strikes. Flying operations at this base have ceased completely and are unlikely to resume. This will ease our efforts to hit other targets in the Kutaisi Country area.")',
		}
	},
	["Needs Oar Point Airbase Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("Needs Oar Point Airbase") < 2',
		action = {
			[1] = 'db_airbases["Needs Oar Point"].inactive = true',
		}
	},
	["Needs Oar Point Airbase Disabled Text"] = {
		active = true,
		once = false,
		condition = 'Return.TargetAlive("Needs Oar Point Airbase") < 2',
		action = {
			[1] = 'Action.Text("The infrastructure at Needs Oar Point Airbase has been destroyed by air strikes. Flying operations at this base have ceased completely and are unlikely to resume. This will ease our efforts to hit other targets in the Kutaisi Country area.")',
		}
	},	
	["Chailey Airbase Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("Chailey Airbase") < 2',
		action = {
			[1] = 'db_airbases["Chailey"].inactive = true',
		}
	},
	["Chailey Airbase Disabled Text"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("Chailey Airbase") < 2',
		action = {
			[1] = 'Action.Text("Recent air strikes have destroyed enemy ground elements running operations at Chailey Airbase. Without their ground support, any remaining aircraft at the airstrip will no longer be able to launch on sorties.")',
		}
	},
	["Ford AF Airbase Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("Ford_AF Airbase") < 2',
		action = {
			[1] = 'db_airbases["Ford AF"].inactive = true',
		}
	},
	["Ford AF Airbase Disabled Text"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("Ford_AF Airbase") < 2',
		action = {
			[1] = 'Action.Text("Recent air strikes have destroyed enemy ground elements running operations at Ford AF Airbase. Without their ground support, any remaining aircraft at the airstrip will no longer be able to launch on sorties.")',
		}
	},
	["Essay Airbase Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("Essay Airbase") < 2',
		action = {
			[1] = 'db_airbases["Essay"].inactive = true',
		}
	},
	["Essay Airbase Disabled Text"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("Essay Airbase") < 2',
		action = {
			[1] = 'Action.Text("Recent air strikes have destroyed enemy ground elements running operations at Essay Airbase. Without their ground support, any remaining aircraft at the airstrip will no longer be able to launch on sorties.")',
		}
	},
	["Evreux Airbase Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("Evreux Airbase") < 2',
		action = {
			[1] = 'db_airbases["Evreux"].inactive = true',
		}
	},
	["Evreux Airbase Disabled Text"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("Evreux Airbase") < 2',
		action = {
			[1] = 'Action.Text("Recent air strikes have destroyed enemy ground elements running operations at Evreux Airbase. Without their ground support, any remaining aircraft at the airstrip will no longer be able to launch on sorties.")',
		}
	},
	["Hauterive Airbase Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("Hauterive Airbase") < 2',
		action = {
			[1] = 'db_airbases["Hauterive"].inactive = true',
		}
	},
	["Hauterive Airbase Disabled Text"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("Hauterive Airbase") < 2',
		action = {
			[1] = 'Action.Text("Recent air strikes have destroyed enemy ground elements running operations at Hauterive Airbase. Without their ground support, any remaining aircraft at the airstrip will no longer be able to launch on sorties.")',
		}
	},
	["Lessay Airbase Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("Lessay Airbase") < 2',
		action = {
			[1] = 'db_airbases["Lessay"].inactive = true',
		}
	},
	["Lessay Airbase Disabled Text"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("Lessay Airbase") < 2',
		action = {
			[1] = 'Action.Text("Recent air strikes have destroyed enemy ground elements running operations at Lessay Airbase. Without their ground support, any remaining aircraft at the airstrip will no longer be able to launch on sorties.")',
		}
	},
	["Maupertus Airbase Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("Maupertus Airbase") < 2',
		action = {
			[1] = 'db_airbases["Maupertus"].inactive = true',
		}
	},
	["Maupertus Airbase Disabled Text"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("Maupertus Airbase") < 2',
		action = {
			[1] = 'Action.Text("Recent air strikes have destroyed enemy ground elements running operations at Maupertus Airbase. Without their ground support, any remaining aircraft at the airstrip will no longer be able to launch on sorties.")',
		}
	},
	["Conches Airbase Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("Conches Airbase") < 2',
		action = {
			[1] = 'db_airbases["Conches"].inactive = true',
		}
	},
	["Conches Airbase Disabled Text"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("Conches Airbase") < 2',
		action = {
			[1] = 'Action.Text("Recent air strikes have destroyed enemy ground elements running operations at Conches Airbase. Without their ground support, any remaining aircraft at the airstrip will no longer be able to launch on sorties.")',
		}
	},
	
	----- RED CAP -----
--[[	["CAP After EWR Destroyed"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("EWR 1 501") == 0 and Return.TargetAlive("EWR 2 502") == 0 and Return.TargetAlive("EWR 3 503") == 0',
		action = {
			[1] = 'Action.TargetActive("CAP Red North", true)',
			[2] = 'Action.TargetActive("CAP Red Center", true)',
			[3] = 'Action.TargetActive("CAP Red South", true)',
			[4] = 'Action.Text("With the recent destruction of all Early Warning Radar sites in the operations area, the ability of the enemy to launch interceptors against our strike packages was severely degraded. Intelligence expects that the enemy will increasingly depend on Combat Air Patrols to compensate, though without the support of ground controllers these are estimated to be of limited effectiveness.")',
		
			[5] = 'Action.TargetActive("Batumi Interception 1", false)',
			[6] = 'Action.TargetActive("Batumi Interception 2", false)',
			[7] = 'Action.TargetActive("Batumi Interception Standby 1", false)',
			[8] = 'Action.TargetActive("Sukhumi Interception 1", false)',
			[9] = 'Action.TargetActive("Sukhumi Interception 2", false)',
			[10] = 'Action.TargetActive("Sukhumi Interception Standby 1", false)',
			[11] = 'Action.TargetActive("Gudauta Interception 1", false)',
			[12] = 'Action.TargetActive("Gudauta Interception 2", false)',
			[13] = 'Action.TargetActive("Kutaisi Interception 1", false)',
			[14] = 'Action.TargetActive("Kutaisi Interception 2", false)',
			[15] = 'Action.TargetActive("Mozdok Interception 1", false)',
			[16] = 'Action.TargetActive("Mozdok Interception 2", false)',
		},
	},	--]]	
	
	----- REPAIR AND REINFORCEMENTS -----
	["Repair"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitRepair()',
	},
	-- Miguel21 modification M19 : Repair SAM
	["GroundUnitRepair"] = {
		active = true,
		condition = 'true',
		action = 'Action.GroundUnitRepair()',
	},
	["Reinforce 352nd Fighter Group"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/P51 Fighter Group", "352nd Fighter Group", 4)',
	},
	["Reinforce 353rd Fighter Group"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/P51 Fighter Group", "353rd Fighter Group", 2)',
	},	
	["Reinforce 360th Fighter Group"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/P51 Escort Group", "360th Fighter Group", 2)',
	},
	["Reinforce No. 24 Squadron RAF"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/RAF", "No. 24 Squadron RAF", 2)',
	},
	["Reinforce No. 19 Squadron RAF"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/RAF", "No. 19 Squadron RAF", 4)',
	},	
	["Reinforce No. 20 Squadron RAF"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/RAF", "No. 20 Squadron RAF", 4)',
	},
	["Reinforce 362 Fighter Group"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/P-47-30", "362 Fighter Group", 4)',
	},
	["Reinforce 363 Fighter Group"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/P-47-30", "363 Fighter Group", 2)',
	},
	["Reinforce 447th Bomb Group"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/Bomb Group", "447th Bomb Group", 4)',
	},
	["Reinforce 640th Bombardment Squadron"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/640th Bombardment Squadron", "640th Bombardment Squadron", 4)',
	},
	["Reinforce Jagdgeschwader 26"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/BF109", "Jagdgeschwader 26", 4)',
	},
	--[[["Reinforce Jagdgeschwader 27"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/BF109", "Jagdgeschwader 27", 8)',
	},--]]
	["Reinforce Jagdgeschwader 28"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/BF109", "Jagdgeschwader 28", 4)',
	},
	["Reinforce Jagdgeschwader 4"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/Anton", "Jagdgeschwader 4", 4)',
	},
	["Reinforce Jagdgeschwader 5"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/Anton", "Jagdgeschwader 5", 2)',
	},
--[[	["Reinforce Jagdgeschwader 6"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/Anton", "Jagdgeschwader 6", 6)',
	},--]]
	["Reinforce Jagdgeschwader 334"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/DORA", "Jagdgeschwader 334", 4)',
	},
	["Reinforce Jagdgeschwader 335"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/DORA", "Jagdgeschwader 335", 2)',
	},
--[[	["Reinforce Jagdgeschwader 336"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/DORA", "Jagdgeschwader 336", 4)',
	},	--]]
	["Reinforce V./Kampfgeschwader 40"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/Junkers", "V./Kampfgeschwader 40", 2)',
	},
	["Reinforce V./Kampfgeschwader 41"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/Junkers", "V./Kampfgeschwader 41", 2)',
	},

	----- AVIATION UNIT STATUS -----
	["Jagdgeschwader 28 Alive 75%"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitAlive("Jagdgeschwader 28") + Return.AirUnitReady("R/BF109") < 45',
		action = 'Action.Text("Aircraft strength of the Jagdgeschwader 28 has fallen below 75%.")',
	},
	["Jagdgeschwader 28 Alive 50%"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitAlive("Jagdgeschwader 28") + Return.AirUnitReady("R/BF109") < 30',
		action = 'Action.Text("Aircraft strength of the Jagdgeschwader 28 has fallen below 50%. If losses continue at the present rate, the combat capability of the squadron is in jeopardy.")',
	},
	["Jagdgeschwader 28 Alive 25%"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitAlive("Jagdgeschwader 28") + Return.AirUnitReady("R/BF109") < 15',
		action = 'Action.Text("Aircraft strength of the Jagdgeschwader 28 has fallen below 25%. The number of available airframes is critically low. The squadron is short of destruction.")',
	},
	
	---- GROUND TARGET STATUS ---
	["Blue Ground Target Briefing Intel"] = {
		active = true,
		condition = 'true',
		action = 'Action.AddGroundTargetIntel("blue")',
	},
	["Red Ground Target Briefing Intel"] = {
		active = true,
		condition = 'true',
		action = 'Action.AddGroundTargetIntel("red")',
	},
	
	
	---- NEWSPAPER ----
--[[
	["Newspaper Fulcrum"] = {
		active = true,
		once = true,
		condition = 'NoMoreNewspaper == nil and Return.Mission() > 1 and math.random(1,10) == 1',
		action = {
			[1] = 'Action.AddImage("Newspaper_Fulcrum.jpg", "blue")',
			[2] = 'NoMoreNewspaper = true',
		},
	},
	["Newspaper Gainful"] = {
		active = true,
		once = true,
		condition = 'NoMoreNewspaper == nil and Return.Mission() > 1 and math.random(1,10) == 1',
		action = {
			[1] = 'Action.AddImage("Newspaper_Gainful.jpg", "blue")',
			[2] = 'NoMoreNewspaper = true',
		},
	},
	["Newspaper Gecko"] = {
		active = true,
		once = true,
		condition = 'NoMoreNewspaper == nil and Return.Mission() > 1 and math.random(1,10) == 1',
		action = {
			[1] = 'Action.AddImage("Newspaper_Gecko.jpg", "blue")',
			[2] = 'NoMoreNewspaper = true',
		},
	}, --]]
}
